<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();
include 'includes/conexao.php';

// Verifica login
if (!isset($_SESSION['logado'])) {
    header("Location: login.php");
    exit;
}

// Busca os apps no banco
$stmt = $conexao->prepare("SELECT * FROM apps ORDER BY id DESC");
$stmt->execute();
$apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
?>

<div class="main-content">
    <div class="glass-container">
        <h1><span class="emoji-pulse">🛍️</span>️ Nossa Loja de Apps</h1>

        <?php if (count($apps) === 0): ?>
            <p class="no-apps">Nenhum app cadastrado até o momento.</p>
        <?php else: ?>
            <div class="app-grid">
                <?php foreach ($apps as $app): ?>
                    <div class="app-card">
                        <div class="app-image">
                            <?php if ($app['imagens'] && file_exists('assets/imagens/' . $app['imagens'])): ?>
                                <img src="<?= 'assets/imagens/' . htmlspecialchars($app['imagens']) ?>" alt="<?= htmlspecialchars($app['nome']) ?>">
                            <?php else: ?>
                                <div class="no-image">Sem imagem</div>
                            <?php endif; ?>
                        </div>
                        <div class="app-info">
                            <h2><?= htmlspecialchars($app['nome']) ?></h2>
                            <p><?= nl2br(htmlspecialchars($app['info'])) ?></p>
                            <?php if ($app['url']): ?>
                                <a href="<?= htmlspecialchars($app['url']) ?>" target="_blank" class="neon-button small-button">Visitar</a>
                            <?php endif; ?>
                            <?php if ($app['apk'] && file_exists('assets/apks/' . $app['apk'])): ?>
                                <a href="<?= 'assets/apks/' . htmlspecialchars($app['apk']) ?>" download class="neon-button small-button">Download</a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .no-apps {
        color: #00f0ff;
        text-align: center;
        font-size: 1.1rem;
        margin-top: 20px;
    }

    .app-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 90px; /* aumentamos o espaço entre os cards */
    margin-top: 30px;
    width: 100%;
    max-width: 1200px;
    margin-left: auto;
    margin-right: auto;
    padding: 0 20px; /* espaço nas laterais da grade */
}

@media (max-width: 1024px) {
    .app-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 600px) {
    .app-grid {
        grid-template-columns: 1fr;
    }
}

.app-card {
    width: 100%;
    padding: 20px;
    border-radius: 15px;
    background: rgba(15, 15, 26, 0.6);
    border: 1px solid #00f0ff;
    backdrop-filter: blur(15px);
    box-shadow: 0 0 20px #00f0ff44;
    display: flex;
    flex-direction: column;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}


    .app-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 0 25px #00f0ffcc, 0 0 40px #00f0ff88;
    }

    .app-image {
        width: 100%;
        height: 180px;
        border-radius: 12px;
        overflow: hidden;
        margin-bottom: 15px;
        background: #001622;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #00f0ff66;
        font-size: 0.9rem;
        user-select: none;
    }

    .app-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 12px;
    }

    .app-info h2 {
        color: #00f0ff;
        margin: 0 0 10px;
        text-shadow: 0 0 8px #00f0ffbb;
        font-size: 1.3rem;
    }

    .app-info p {
        color: #cceeffcc;
        flex-grow: 1;
        font-size: 0.95rem;
        white-space: pre-wrap;
        margin-bottom: 15px;
        line-height: 1.4;
    }

    .neon-button.small-button {
        background: transparent;
        border: 2px solid #00f0ff;
        color: #00f0ff;
        padding: 8px 14px;
        font-size: 0.9rem;
        border-radius: 8px;
        margin-right: 10px;
        cursor: pointer;
        text-decoration: none;
        display: block;          /* Faz o botão ocupar a linha toda */
        width: 90%;   
        transition: all 0.3s ease;
    }

    .neon-button.small-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 15px #00f0ff;
        transform: translateY(-2px);
    }

    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
            filter: drop-shadow(0 0 5px #00f0ff);
        }
        50% {
            transform: scale(1.3);
            filter: drop-shadow(0 0 25px #00f0ff);
        }
    }

    .emoji-pulse {
        display: inline-block;
        animation: pulse 2s infinite ease-in-out;
    }
</style>
