<?php
//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->

session_start();
include 'includes/conexao.php';

if (!isset($_SESSION['logado'])) {
    header("Location: login.php");
    exit;
}

// Processa o formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!file_exists('assets/apks')) {
        mkdir('assets/apks', 0777, true);
    }
    if (!file_exists('assets/imagens')) {
        mkdir('assets/imagens', 0777, true);
    }

    $nome = $_POST['nome'];
    $url = $_POST['url'] ?? '';
    $info = $_POST['info'];
    
    // Código opcional: se vazio, será null
    $codigo = isset($_POST['codigo']) && $_POST['codigo'] !== '' ? intval($_POST['codigo']) : null;

    // Verifica se código já existe (somente se código informado)
    if ($codigo !== null) {
        $stmtVerifica = $conexao->prepare("SELECT COUNT(*) FROM apps WHERE codigo = ?");
        $stmtVerifica->execute([$codigo]);
        if ($stmtVerifica->fetchColumn() > 0) {
            $erro = "⚠️ O código $codigo já está em uso. Escolha outro.";
        }
    }

    if (!isset($erro)) {
        $nomeAppArquivo = preg_replace('/[^a-zA-Z0-9]/', '_', $nome);
        $nomeAppArquivo = strtoupper($nomeAppArquivo);

        // Upload da imagem
        $imagem = '';
        if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === UPLOAD_ERR_OK) {
            $extImagem = pathinfo($_FILES['imagem']['name'], PATHINFO_EXTENSION);
            $imagem = $nomeAppArquivo . '.' . $extImagem;
            move_uploaded_file($_FILES['imagem']['tmp_name'], 'assets/imagens/' . $imagem);
        }

        // Upload do arquivo
        $arquivo = '';
        if (isset($_FILES['arquivo']) && $_FILES['arquivo']['error'] === UPLOAD_ERR_OK) {
            $extArquivo = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
            $arquivo = $nomeAppArquivo . '.' . $extArquivo;
            move_uploaded_file($_FILES['arquivo']['tmp_name'], 'assets/apks/' . $arquivo);
        }

        try {
            $stmt = $conexao->prepare("INSERT INTO apps (nome, url, info, apk, imagens, codigo) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([$nome, $url, $info, $arquivo, $imagem, $codigo]);

            $_SESSION['mensagem'] = "App cadastrado com sucesso!";
            header("Location: dashboard.php");
            exit;
        } catch (PDOException $e) {
            $erro = "Erro ao salvar: " . $e->getMessage();
        }
    }
}

// Mensagem flash
$mensagem = $_SESSION['mensagem'] ?? '';
unset($_SESSION['mensagem']);

include 'includes/header.php';
?>

<div class="main-content">
    <div class="glass-container">
        <h1 class="neon-title">📲 CADASTRAR NOVO APP</h1>

        <?php if ($mensagem): ?>
            <div class="alert neon-success" id="mensagem-flash">
                <?= htmlspecialchars($mensagem) ?>
            </div>
            <script>
                setTimeout(() => {
                    document.getElementById('mensagem-flash').style.display = 'none';
                }, 3000);
            </script>
        <?php endif; ?>

        <?php if (isset($erro)): ?>
            <div class="alert neon-error"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>

        <form method="POST" enctype="multipart/form-data" class="neon-form">
            <div class="input-group">
                <label>🔷 Nome do App</label>
                <input type="text" name="nome" placeholder="Ex: App Futurista 3000" required>
            </div>

            <div class="input-group">
                <label>🌄 Imagem (Capa)</label>
                <input type="file" name="imagem" accept="image/*" required>
            </div>

            <div class="input-group">
                <label>🔗 URL (Opcional)</label>
                <input type="url" name="url" placeholder="https://">
            </div>

            <div class="input-group">
                <label>📦 Arquivo (.APK, .EXE)</label>
                <input type="file" name="arquivo" required>
            </div>

            <div class="input-group">
                <label>📝 Informações</label>
                <textarea name="info" rows="4" placeholder="Descreva o app..." required></textarea>
            </div>

            <div class="input-group">
                <label>🔢 Código do App (apenas números) — Opcional</label>
                <input type="number" name="codigo" placeholder="Ex: 123456">
            </div>

            <button type="submit" class="neon-button">🚀 PUBLICAR APP</button>
        </form>
    </div>
</div>

<style>
    body {
        margin: 0;
        padding: 0;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        background-color: #0f0f1a;
    }

    .main-content {
        padding: 20px;
        display: flex;
        justify-content: center;
        align-items: center;
        flex: 1;
    }

    .glass-container {
        background: rgba(15, 15, 26, 0.7);
        backdrop-filter: blur(12px);
        border: 1px solid #00f0ff;
        border-radius: 15px;
        padding: 30px;
        width: 100%;
        max-width: 600px;
        box-shadow: 0 0 25px rgba(0, 240, 255, 0.2);
        margin: 20px 0;
    }

    .neon-title {
        color: #00f0ff;
        text-align: center;
        font-size: 1.8rem;
        margin-bottom: 25px;
        text-shadow: 0 0 10px rgba(0, 240, 255, 0.7);
    }

    .neon-form {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .input-group {
        width: 100%;
    }

    .input-group label {
        display: block;
        margin-bottom: 8px;
        color: #00f0ff;
        font-size: 0.9rem;
    }

    .input-group input,
    .input-group textarea,
    .input-group input[type="file"] {
        width: calc(100% - 24px);
        padding: 12px;
        background: rgba(0, 0, 30, 0.5);
        border: 1px solid #00f0ff;
        border-radius: 8px;
        color: white;
        font-size: 1rem;
        transition: all 0.3s;
    }

    .input-group textarea {
        resize: vertical;
        min-height: 100px;
    }

    .input-group input:focus,
    .input-group textarea:focus {
        outline: none;
        border-color: #00b7ff;
        box-shadow: 0 0 10px rgba(0, 183, 255, 0.5);
    }

    .neon-button {
        background: transparent;
        color: #00f0ff;
        border: 2px solid #00f0ff;
        padding: 12px;
        font-size: 1.1rem;
        cursor: pointer;
        border-radius: 8px;
        transition: all 0.3s;
        margin-top: 10px;
        width: 100%;
    }

    .neon-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 20px #00f0ff;
        transform: translateY(-2px);
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        text-align: center;
        width: 100%;
    }

    .neon-success {
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid #00ff88;
        color: #00ff88;
    }

    .neon-error {
        background: rgba(255, 85, 85, 0.1);
        border: 1px solid #ff5555;
        color: #ff5555;
    }
</style>
